
var WlanStateNotReady = 0;
var WlanStateConnected = 1;
var WlanStateAdHocNetworkFormed = 2;
var WlanStateDisconnecting = 3;
var WlanStateDisconnected = 4;
var WlanStateAssociating = 5;
var WlanStateDiscovering = 6;
var WlanStateAuthenticating = 7;

var WlanModeProfile = 0;
var WlanModeTemporaryProfile = 1;
var WlanModeDiscoverySecure = 2;
var WlanModeDiscoveryUnsecure = 3;
var WlanModeAuto = 4;
var WlanModeInvalid = 5;

var WlanCipherNone = 0x0;
var WlanCipherWep40 = 0x01;
var WlanCipherTkip = 0x02;
var WlanCipherCcmp = 0x04; //AES
var WlanCipherAes = 0x04; //AES
var WlanCipherWep104 = 0x05;
var WlanCipherWpaUseGroup = 0x100;
var WlanCipherRsnUseGroup = 0x100;
var WlanCipherWep = 0x101;

var WlanAuthOpen = 1;
var WlanAuthSharedKey = 2;
var WlanAuthWpa = 3;
var WlanAuthWpaPsk = 4;
var WlanAuthWpaNone = 5;
var WlanAuthRsna = 6; //WPA2
var WlanAuthWpa2 = 6; //WPA2
var WlanAuthRsnaPsk = 7; //WPA2-PSK
var WlanAuthWpa2Psk = 7; //WPA2-PSK

var WlanPhyTypeUnknown = 0;
var WlanPhyTypeAny = 0;
var WlanPhyTypeFhss = 1;
var WlanPhyTypeDsss = 2;
var WlanPhyTypeIrBaseBand = 3;
var WlanPhyTypeOfdm = 4; //A
var WlanPhyTypeA = 4; //A
var WlanPhyTypeHrdsss = 5; //B
var WlanPhyTypeB = 5; //B
var WlanPhyTypeErp = 6; //G
var WlanPhyTypeG = 6; //G
var WlanPhyTypeHt = 7; //N
var WlanPhyTypeN = 7; //N


function GetWLanSigBarsFromPerc(qual)
{
	//INT ss = (qual+1)/20; //if(!ss) ss = 1;

	if(qual >= 75)
		return 4;
	else if(qual >= 50)
		return 3;
	else if(qual >= 25)
		return 2;
	else if(qual >= 2)
		return 1;

	return 0;
}
function WirelessSecurityString(auth, ciph)
{
	if(auth == WlanAuthOpen && (ciph == WlanCipherWep40 || ciph == WlanCipherWep104 || ciph == WlanCipherWep))
		return "WEP";
		
	var ret = "";
	switch(auth)
	{
		case WlanAuthOpen:
			ret = "Open";
		break;
		case WlanAuthWpaPsk:
			ret = "WPA-PSK";
		break;
		case WlanAuthWpa2Psk:
			ret = "WPA2-PSK";
		break;
		case WlanAuthWpa:
			ret = "WPA";
		break;
		case WlanAuthWpa2:
			ret = "WPA2";
		break;
		default:
			//ret = "Open";
		break;		
	}
	
	switch(ciph)
	{
		case WlanCipherWep40:
		case WlanCipherWep104:
		case WlanCipherWep:
			ret += " (WEP)";
		break;
		case WlanCipherTkip:
			ret += " (TKIP)";
		break;
		case WlanCipherAes:
			ret += " (AES)";
		break;
		default:
			//ret = "Open";
		break;		
	}	
	
	return ret;
}

/*
window.cefApplication.Wireless.GetInfo() Object Model

AdapterGuid : (string)
ConnectionName : (string)
AdapterName : (string)
AdapterState : (EthernetState*) (see cefEthernet.js)
Wlan : (object)
	RadioEnabled : (bool)
	NumberOfAvailableNetworks : (int)
	CurrentConnection : (object)
		ProfileName : (object)
		State : (WlanState*)
		ConnectionMode : (WlanMode*)
		Ssid : (string)
		PhysicalType : (WlanPhyType*)
		SignalQuality : (int)
		SecurityCipherAlgorithm : (WlanCipher*)
		SecurityAuthAlgorithm : (WlanAuth*)
		SecurityEnabled : (bool)
*/



